clear all

global path "E:\Project1_empirical" // global path file
global census2005 "$path\2005Census" // 2005 Census data

use $census2005\data_num.dta

sum r4_02 // year of birth //

*keep if r31==2 // first marriage //

keep if r4_02>=1960

*r11 1 agri 2 non-agri

gen marry = (r32_02)-(r4_02) // age of marriage //

sum marry

keep if marry>=14 & marry<=45

/* twoway (histogram marry, width(1) percent) || ///
(kdensity marry, area(407650)) */

twoway histogram marry if r3==1 & r11==2, percent width(1) ///
xtitle("Age at first marriage") ytitle("Percentage") /// 
title("Urban Male") name(male)

twoway histogram marry if r3==2 & r11==2, percent width(1) ///
xtitle("Age at first marriage") ytitle("Percentage") /// 
title("Urban Female") name(female)

*graph combine male female
*graph export "F:\OCP\Age of marriage_male.png", as(png) replace

*graph export "F:\OCP\Age of marriage_female.png", as(png) replace
